<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }


    // This is your option name where all the Redux data is stored.
    $opt_name = "kolo";

    // This line is only for altering the demo. Can be easily removed.
    $opt_name = apply_filters( 'kolo/opt_name', $opt_name );

    /*
     *
     * --> Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
     *
     */

    $sampleHTML = '';
    if ( file_exists( get_template_directory() . '/info-html.html' ) ) {
        Redux_Functions::initWpFilesystem();

        global $wp_filesystem;

        $sampleHTML = $wp_filesystem->get_contents( get_template_directory() . '/info-html.html' );
    }

    // Background Patterns Reader
    $sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';
    $sample_patterns_url  = ReduxFramework::$_url . '../sample/patterns/';
    $sample_patterns      = array();

    if ( is_dir( $sample_patterns_path ) ) {

        if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
            $sample_patterns = array();

            while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

                if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $sample_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                    $sample_patterns[] = array(
                        'alt' => $name,
                        'img' => $sample_patterns_url . $sample_patterns_file
                    );
                }
            }
        }
    }

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,

         'disable_tracking' => true,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'submenu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => esc_html__( 'Kolo Options', 'kolo' ),
        'page_title'           => esc_html__( 'Kolo Options', 'kolo' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => false,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

    );

 

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = sprintf( esc_html__( '', 'kolo' ), $v );
    } else {
        $args['intro_text'] = esc_html__( '', 'kolo' );
    }

    // Add content after the form.
    $args['footer_text'] = esc_html__( '', 'kolo' );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => esc_html__( 'Theme Information 1', 'kolo' ),
            'content' => esc_html__( '<p>This is the tab content, HTML is allowed.</p>', 'kolo' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => esc_html__( 'Theme Information 2', 'kolo' ),
            'content' => esc_html__( '<p>This is the tab content, HTML is allowed.</p>', 'kolo' )
        )
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = esc_html__( '<p>This is the sidebar content, HTML is allowed.</p>', 'kolo' );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    /*

        As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


     */

      // -> START Basic Fields

    Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'General Settings', 'kolo' ),
		'desc'   => esc_html__( '', 'kolo' ),
		'icon'   => 'el el-cog',
		'fields' => array(

			array(
				'id'       => 'kolo_home_logo_ico',
				'type'     => 'media',
				'compiler' => true,
				'title'    => esc_html__('Logo Upload', 'kolo'), 
				'subtitle' => esc_html__('upload your logo', 'kolo'),
				'default'  => array(
						   'url'=> get_template_directory_uri().'/img/logo.png'
				  ),
			),
			array(
				'id'       => 'kolo_home_banner_img',
				'type'     => 'media',
				'compiler' => true,
				'title'    => esc_html__('Header Banner Image', 'kolo'), 
				'subtitle' => esc_html__('upload banner image here', 'kolo'),
				'default'  => array(
						   'url'=> get_template_directory_uri().'/img/parallax_bg/bottom-promo-line.jpg'
				  ),
			),                        
			array(
				'id'       => 'kolo_menu_text_color',
				'type'     => 'color',
				'title'    => esc_html__('Menu Text Color', 'kolo'), 
				'subtitle' => esc_html__('Choice color here', 'kolo'),
				'default'  => '#222222'
			),						
			array(
				'id'       => 'kolo_menu_text_hover_acive_color',
				'type'     => 'color',
				'title'    => esc_html__('Menu Text Hover / Active Color', 'kolo'), 
				'subtitle' => esc_html__('Choice color here', 'kolo'),
				'default'  => '#0ea29d'
			),					
			array(
				'id'       => 'kolo_menu_bg_color',
				'type'     => 'color',
				'title'    => esc_html__('Menu Backgrund Color', 'kolo'), 
				'subtitle' => esc_html__('Choice color here', 'kolo'),
				'default'  => '#ffffff'
			),		
		)
    ) ); 

    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Footer Settings', 'kolo' ),
        'id'               => 'kolo-foooter-setting',
        'icon'             => 'el el-stop-alt',
        'customizer_width' => '400px',
        'fields'           => array(

            array(
                'id'       => 'kolo_copywrite_text',
                'type'             => 'editor',
                'title'            => esc_html__('CopyWrite Text', 'kolo'), 
                'subtitle'         => esc_html__('Write Copywrite text here.', 'kolo'),
                'default'          => 'Copyright 2016 <span>Kolo</span> Limited. All Rights Reserved.',
                'args'   => array(
                    'teeny'            => true,
                    'textarea_rows'    => 4
                )
            ),
		
			array(
                'id'       => 'kolo_footer_text_color',
                'type'             => 'color',
                'title'            => esc_html__('Footer Text Color', 'kolo'), 
                'subtitle'         => esc_html__('choice color here.', 'kolo'),		
                'default'         => '#444444',		
            ),			
			
			array(
                'id'       => 'kolo_footer_link_hover_color',
                'type'             => 'color',
                'title'            => esc_html__('Footer Link Hover Color', 'kolo'), 
                'subtitle'         => esc_html__('choice color here.', 'kolo'),		
                'default'         => '#0ea29d',		
            ),            
					
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Advance Settings', 'kolo' ),
        'id'               => 'kolo-advance-setting',
        'customizer_width' => '400px',
        'fields'           => array(

			array(
                'id'       => 'kolo_theme_color',
                'type'             => 'color',
                'title'            => esc_html__('Theme Color', 'kolo'), 
                'subtitle'         => esc_html__('choice color here', 'kolo'),
            ),					
			
			array(
                'id'       => 'kolo_theme_hover_color',
                'type'             => 'color',
                'title'            => esc_html__('Theme Hover Color', 'kolo'), 
                'subtitle'         => esc_html__('choice color here', 'kolo'),
            ),		
			
            array(
                'id'       => 'kolo_preloader_opt',
                'type'     => 'switch',
                'title'    => esc_html__('Display Preloader', 'kolo'),
                'subtitle' => esc_html__('If yes then click the checkbox.', 'kolo'),
                'default'  => '1'// 1 = on | 0 = off
            ),  
			array(
                'id'       => 'kolo_homepage_opt',
                'type'             => 'checkbox',
                'title'            => esc_html__('Only Enable Home Page', 'kolo'), 
				'default'  => '0',
                'subtitle'         => esc_html__('if check this option preloader only will be enable for home page', 'kolo'),
				'required' => array( 'kolo_preloader_opt', '=', '1' ),
            ),				
			
			array(
                'id'       => 'kolo_preloader_bg_color',
                'type'             => 'color',
                'title'            => esc_html__('Preloader Background Color', 'kolo'), 
				'default'  => '#0ea29d',
                'subtitle'         => esc_html__('choice color here', 'kolo'),
				'required' => array( 'kolo_preloader_opt', '=', '1' ),
            ),		

			array(
                'id'       => 'kolo_preloader_imge',
                'type'             => 'media',
                'title'            => esc_html__('Preloader Background Color', 'kolo'), 
				'default'  => array(
					'url'	=> get_template_directory_uri(). '/img/icons/loader.GIF'
				),
                'subtitle'         => esc_html__('upload preloader image here', 'kolo'),
				'required' => array( 'kolo_preloader_opt', '=', '1' ),
            ),	
			
            array(
                'id'       => 'kolo_css_editor',
                'type'     => 'ace_editor',
                'title'    => esc_html__('Custom CSS', 'kolo'),
                'subtitle' => esc_html__('Write your CSS code here.', 'kolo'),
                'mode'     => 'css',
                'theme'    => 'monokai',
            ),
			
			

        )
    ) );




    Redux::setSection( $opt_name, array(
        'icon'            => 'el el-list-alt',
        'title'           => esc_html__( 'Customizer Only', 'kolo' ),
        'desc'            => esc_html__( '<p class="description">This Section should be visible only in Customizer</p>', 'kolo' ),
        'customizer_only' => true,
        'fields'          => array(
            array(
                'id'              => 'opt-customizer-only',
                'type'            => 'select',
                'title'           => esc_html__( 'Customizer Only Option', 'kolo' ),
                'subtitle'        => esc_html__( 'The subtitle is NOT visible in customizer', 'kolo' ),
                'desc'            => esc_html__( 'The field desc is NOT visible in customizer.', 'kolo' ),
                'customizer_only' => true,
                //Must provide key => value pairs for select options
                'options'         => array(
                    '1' => esc_html__('Opt 1', 'kolo'),
                    '2' => esc_html__('Opt 2' , 'kolo'),
                    '3' => esc_html__('Opt 3' , 'kolo')
                ),
                'default'         => '2'
            ),
        )
    ) );

    if ( file_exists( get_template_directory() . '/../README.md' ) ) {
        $section = array(
            'icon'   => 'el el-list-alt',
            'title'  => esc_html__( 'Documentation', 'kolo' ),
            'fields' => array(
                array(
                    'id'       => '17',
                    'type'     => 'raw',
                    'markdown' => true,
                    'content_path' => get_template_directory() . '/../README.md', // FULL PATH, not relative please
                    //'content' => 'Raw content here',
                ),
            ),
        );
        Redux::setSection( $opt_name, $section );
    }
    /*
     * <--- END SECTIONS
     */


 