<?php
 
add_action('init', 'kolo_kc_active', 99 );
 
function kolo_kc_active() {
 
	if (function_exists('kc_add_map')) 
		
	{ 
	
	    kc_add_map(
	        array(

	            'shortcode_importer' => array(
	                'name' => esc_html__('Shortcode Importer', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(
	                
	                    array(
                        'name' => 'enter_shortcode',
                        'label' => esc_html__( 'Enter Shortcode', 'kolo' ),
                        'type' => 'textarea',
                        'admin_label' => true,
						),	    	                             


	                )
	            ),  // End of elemnt kc_icon 

	        ) 
			
			
	    ); // End add map	  
		
	    kc_add_map(
	        array(

	            'title_area' => array(
	                'name' => esc_html__('Section Title', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(
	                
						array(
	                        'name' => 'sec_title',
	                        'label' => esc_html__( 'Section Title', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,	
	                        'value' => 'FAQs',	
						
						),	   						
						
						array(
	                        'name' => 'sec_subtitle',
	                        'label' => esc_html__( 'Section Content', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,	
	                        'value' => 'Sagittis an accumsan convallis, lectus ultrices feugiat ',	
						
						),	  						
						
		

	                )
	            ),  // End of elemnt kc_icon 

	        ) 
			
			
	    ); // End add map	    
		
		kc_add_map(
	        array(

	            'normal_register_Banner' => array(
	                'name' => esc_html__('Banner - Normal Register Form', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(

	                    array(
	                        'name' => 'bg_img',
	                        'label' => esc_html__( 'Upload Background Image', 'kolo' ),
	                        'type' => 'attach_image',
	                        'admin_label' => true,
						),		                    
						
						array(
	                        'name' => 'sec_heading',
	                        'label' => esc_html__( 'Section Heading', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
							'value' => 'KOLO is the <span>most simple way</span> to launch your startup',
						),	 						
						
						array(
	                        'name' => 'sec_subheading',
	                        'label' => esc_html__( 'Section Sub Heading', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
							'value' => 'Vivamus ultrices luctus quam eu feugiat posuere pulvinar turpis quis interdum vulputate lobortis diam  lectus
							ante ut urna malesuada, ultrices luctus maximus mollis feugiat accumsan aliquam vitae malesuada rutrum',
						),								
						
						array(
	                        'name' => 'learn_more_text',
	                        'label' => esc_html__( 'Learn More Button Text', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'Learn more',
						),							
						
						array(
	                        'name' => 'learn_more_link',
	                        'label' => esc_html__( 'Learn More Button Link', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => '#',
						),								

						array(
	                        'name' => 'get_started_text',
	                        'label' => esc_html__( 'Get Started Button Text', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'Get started now',
						),							
						
						array(
	                        'name' => 'get_started_link',
	                        'label' => esc_html__( 'Get Started Button Link', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => '#',
						),							
						
						array(
	                        'name' => 'c_f7s_id',
	                        'label' => esc_html__( 'Contact Form7 Shortcode ID', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
						),								
						
								
	                )
	            ),  // End of elemnt kc_icon 

	        ) 
			
			
	    ); // End add map			
		
		kc_add_map(
	        array(

	            'simple_register_Banner' => array(
	                'name' => esc_html__('Banner - Simple Register Form', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(

	                    array(
	                        'name' => 'bg_img',
	                        'label' => esc_html__( 'Upload Background Image', 'kolo' ),
	                        'type' => 'attach_image',
	                        'admin_label' => true,
						),		                    
						array(
	                        'name' => 'sec_heading',
	                        'label' => esc_html__( 'Section Heading', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
							'value' => 'Start your project with <span>KOLO</span>',
						),						
						array(
	                        'name' => 'sec_subheading',
	                        'label' => esc_html__( 'Section Sub Heading', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
							'value' => 'We love to create awesome designs for our clients',
						),								
						array(
	                        'name' => 'c_f7s_id',
	                        'label' => esc_html__( 'Contact Form7 Shortcode ID', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
						),						   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 
			
			
	    ); // End add map			

		kc_add_map(
	        array(

	            'big_image_Banner' => array(
	                'name' => esc_html__('Banner - BIG Promo Image', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(

	                    array(
	                        'name' => 'bg_img',
	                        'label' => esc_html__( 'Upload Background Image', 'kolo' ),
	                        'type' => 'attach_image',
	                        'admin_label' => true,
						),		                   

						array(
	                        'name' => 'sec_bg_img',
	                        'label' => esc_html__( 'Upload Section Image', 'kolo' ),
	                        'type' => 'attach_image',
	                        'admin_label' => true,
						),		                    
						array(
	                        'name' => 'sec_heading',
	                        'label' => esc_html__( 'Section Heading', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
							'value' => 'KOLO is the better way to get a awesome design',
						),						
						array(
	                        'name' => 'sec_subheading',
	                        'label' => esc_html__( 'Section Sub Heading', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
							'value' => 'Morbi placerat quam vitae maximus mollis. Donec mattis justo sit amet aliquam efficitur. Donec fermentum 
								ante ut urna malesuada, ultrices luctus maximus mollis feugiat accumsan posuere',
						),								
				   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 
			
			
	    ); // End add map			
		
		kc_add_map(
	        array(

	            'service_area' => array(
	                'name' => esc_html__('Service', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(

	                    array(
	                        'name' => 'ser_icon',
	                        'label' => esc_html__( 'Service Icon', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'fa-diamond',
						),		           

						array(
	                        'name' => 'ser_title',
	                        'label' => esc_html__( 'Service Title', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'Modern Design',
						),							
						
						array(
	                        'name' => 'ser_subtitle',
	                        'label' => esc_html__( 'Service Content', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
							'value' => 'Proin a velit aliquam vitae malesuada rutrum. Aenean ullamcorper placerat porttitor velit aliquam vitae. Aliquam a augue suscipit, bibendum luctus neque laoreet rhoncus ipsum, ullamcorper',
						),							
												       			
												   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 
			
			
	    ); // End add map			
		
		kc_add_map(
	        array(

	            'our_process_area' => array(
	                'name' => esc_html__('Our Process', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(
	                  

						array(
	                        'name' => 'process_title',
	                        'label' => esc_html__( 'Process Title', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'Truly Multipurpose',
						),								

						array(
	                        'name' => 'process_img',
	                        'label' => esc_html__( 'Process Image', 'kolo' ),
	                        'type' => 'attach_image',
	                        'admin_label' => true,
						),			                   
																						
						array(
	                        'name' => 'process_content',
	                        'label' => esc_html__( 'Process Content', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
	                        'value' => 'Maecenas laoreet augue egestas volutpat vulputate fermentum suscipit egestas lobortis magna, fermentum 
							mauris interdum lectus ornare sagittis elementum vulputate congue gestas volutpat',
							
						),			                   
					
												   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map				
		
		kc_add_map(
	        array(

	            'about_us_area' => array(
	                'name' => esc_html__('About Us', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(

	                    array(
	                        'name' => 'sec_title',
	                        'label' => esc_html__( 'Section Title', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'About Us',
						),			                   
	                    array(
	                        'name' => 'sec_subtitle',
	                        'label' => esc_html__( 'Section Subtitle', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
							'value' => 'Sagittis an accumsan convallis, lectus ultrices feugiat',
						),		                   
						array(
	                        'name' => 'about_title',
	                        'label' => esc_html__( 'Section Second Title', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'What we do?',
						),		  					

						array(
	                        'name' => 'about_content',
	                        'label' => esc_html__( 'About Content', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
							'value' => 'Nemo enim ipsam voluptatem, quia voluptas sit, aspernatur consequuntur magni 
						   dolores eos, qui ratione voluptatem sequi nesciunt, neque porro quisquam 
						   tempora incidunt, ut labore et dolore magnam aliquam quaerat voluptatem.',
						),							
						
						array(
	                        'name' => 'about_tab_opt',
	                        'label' => esc_html__( 'Show Tab', 'kolo' ),
	                        'type' => 'select',
	                        'admin_label' => true,
							'options' => array(  // THIS FIELD REQUIRED THE PARAM OPTIONS
								'1' => 'Yes',
								'0' => 'No',
							)							
						),							
						
						array(
	                        'name' => 'about_img',
	                        'label' => esc_html__( 'About Image', 'kolo' ),
	                        'type' => 'attach_image',
	                        'admin_label' => true,
								
						),		                 
					
												   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map			
		
		kc_add_map(
	        array(

	            'promo_area' => array(
	                'name' => esc_html__('Promo Area', 'kolo'),
	                'icon' => 'sl-rocket',	
					'nested'		=> true,					
	                'category' => 'Kolo Shortcodes',
	                'params' => array(

	                    array(
	                        'name' => 'promo_title',
	                        'label' => esc_html__( 'Promo Title', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'Everything that matters to your success',
						),	  	                 

						array(
	                        'name' => 'promo_content',
	                        'label' => esc_html__( 'Promo Content', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
							'value' => '<p>Aenean blandit non nulla at sodales. Sed ut nisi eu dui accumsan mollis quisque erat diam, sodales consequat</p>	
							<p>Proin a velit aliquam vitae malesuada aenean ullamcorper placerat porttitor velit aliquam vitae bibendum luctus, ullamcorper
							   placerat aenean porttitor sodales vitae consequat aenean 
							</p>
							<p>Maecenas laoreet augue egestas volutpat vulputate fermentum suscipit egestas lobortis magna, fermentum condimentum mauris nec interdum lectus ornare 
							   at sagittis elementum vulputate congue Curabitur et turpis urna. In molestie imperdiet metus, a laoreet massa sollicitudin. 
							   Fusce tempus orci sit amet scelerisque volutpat. Nulla dolor sapien, fringilla risus nec, luctus porttitor mauris donec diam euismod
							</p>',
						),	  						
						
						array(
	                        'name' => 'promo_work_btn_text',
	                        'label' => esc_html__( 'Work Button Text', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'View our works',
						),	   						
						
						array(
	                        'name' => 'promo_work_btn_url',
	                        'label' => esc_html__( 'Work Button Url', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => '#',
						),						

						array(
	                        'name' => 'promo_buy_btn_text',
	                        'label' => esc_html__( 'Buy Button Text', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'Buy the theme',
						),	   						
						
						array(
	                        'name' => 'promo_buy_btn_url',
	                        'label' => esc_html__( 'Buy Button Url', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => '#',
						),	                  
					
												   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map			
		
		kc_add_map(
	        array(

	            'promo_slider' => array(
	                'name' => esc_html__('Child Of Promo Area', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(

	                    array(
	                        'name' => 'promo_slider_img',
	                        'label' => esc_html__( 'Upload Image', 'kolo' ),
	                        'type' => 'attach_image',
	                        'admin_label' => true,
						),		                  
								   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map			
		
		kc_add_map(
	        array(

	            'about_us_two' => array(
	                'name' => esc_html__('About Us Two', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(

	                    array(
	                        'name' => 'sec_title1',
	                        'label' => esc_html__( 'Section Title One', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'Our Philosophy'
						),		                    
						
						array(
	                        'name' => 'sec_subtitle1',
	                        'label' => esc_html__( 'Section Subtitle One', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
							'value' => '<p>Nemo enim ipsam voluptatem, quia voluptas sit, aspernatur aut odit aut fugit, sed quia consequuntur magni 
							   dolores eos, qui ratione voluptatem sequi nesciunt, neque porro quisquam dolorem ipsum, tempora incidunt, magnam aliquam
							</p>
							
							<p>Aliquam a augue suscipit, bibendum luctus neque. Vestibulum laoreet rhoncus ipsum, bibendum ullamcorper hendrerit tellus
							   varius nulla mauris, vitae adipiscing
							</p>'
						),		
						
	                    array(
	                        'name' => 'sec_title2',
	                        'label' => esc_html__( 'Section Title Two', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'Discover more about us'
						),		                    
						
						array(
	                        'name' => 'sec_subtitle2',
	                        'label' => esc_html__( 'Section Subtitle Two', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
							'value' => 'Nemo enim ipsam voluptatem, quia voluptas sit, aspernatur aut odit aut fugit, sed quia consequuntur magni 
								dolores eos, qui ratione voluptatem sequi nesciunt bibendum sem a mi accumsan, fringilla nisi rutrum maximus blandit vulputate'
						),						
						
						array(
	                        'name' => 'sec_video_url',
	                        'label' => esc_html__( 'Youtube Url', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'http://www.youtube.com/embed/XSo4JQnm8Bw?rel=0'
						),								
						
						array(
	                        'name' => 'ac_option',
	                        'label' => esc_html__( 'Show Accordion', 'kolo' ),
	                        'type' => 'select',
	                        'admin_label' => true,
							'options' => array(  // THIS FIELD REQUIRED THE PARAM OPTIONS
								'1' => 'Yes',
								'0' => 'No',
							)	
							),		                 
               
								   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map				
		
		kc_add_map(
	        array(

	            'statistic_banner' => array(
	                'name' => esc_html__('Statistic banner', 'kolo'),
	                'icon' => 'sl-rocket',
					'nested'		=> true,
	                'category' => 'Kolo Shortcodes',
	                'params' => array(

	                    array(
	                        'name' => 'satis_img',
	                        'label' => esc_html__( 'Upload Background Image', 'kolo' ),
	                        'type' => 'attach_image',
	                        'admin_label' => true,
						),			                  

					
								   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map			
		
		kc_add_map(
	        array(

	            'statistic_single' => array(
	                'name' => esc_html__('Child of Statistic', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(	                  

						array(
	                        'name' => 'set_number',
	                        'label' => esc_html__( 'Number', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => '125'
						),						

						array(
	                        'name' => 'set_title',
	                        'label' => esc_html__( 'Text', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'Finished projects'
						),							
						
						array(
	                        'name' => 'set_subtitle',
	                        'label' => esc_html__( 'Sub Title', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
							'value' => 'Proin a velit aliquam vitae malesuada aenean placerat porttitor aliquam'
						),							
								   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map			
		
		kc_add_map(
	        array(

	            'kteam_member' => array(
	                'name' => esc_html__('Team', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(

	                    array(
	                        'name' => 'sec_title',
	                        'label' => esc_html__( 'Section Title', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'Meet Our Team'
						),			                  

						array(
	                        'name' => 'set_subtitle',
	                        'label' => esc_html__( 'Section SubTitle', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
							'value' => 'Sagittis an accumsan convallis, lectus ultrices feugiat'
						),							
						
						array(
	                        'name' => 'numb_of_post',
	                        'label' => esc_html__( 'Number of Post', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => '4'
						),										
								   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map				
		
		kc_add_map(
	        array(

	            'promo_area2' => array(
	                'name' => esc_html__('Promo Two', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(

	                    array(
	                        'name' => 'sec_img',
	                        'label' => esc_html__( 'Section Image', 'kolo' ),
	                        'type' => 'attach_image',
	                        'admin_label' => true,
						),			                  

						array(
	                        'name' => 'pro_title',
	                        'label' => esc_html__( 'Section Title', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
							'value' => 'Perfect landing page for startup. Everything your bussiness need in one place',
						),							
						
						array(
	                        'name' => 'pro_content',
	                        'label' => esc_html__( 'Section Content', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
							'value' => '<p>Nemo enim ipsam voluptatem, quia voluptas sit, aspernatur aut odit aut fugit, sed quia consequuntur magni 
							   dolores eos, qui ratione voluptatem sequi nesciunt, neque porro quisquam est, qui dolorem ipsum, quia dolor sit, 
							   Numquam eius modi tempora incidunt, ut labore et dolore magnam aliquam quaerat voluptatem.
							</p>
							
							<p>Aliquam a augue suscipit, bibendum luctus neque. Vestibulum laoreet rhoncus ipsum, bibendum ullamcorper hendrerit tellus</p>
							
							<p>Aliquam a augue suscipit, bibendum luctus neque. Vestibulum laoreet rhoncus ipsum, bibendum ullamcorper hendrerit tellus
							   Vestibulum varius nulla mauris, vitae adipiscing dolores eos, qui ratione voluptatem sequi nesciunt
							</p>',
						),					

						array(
	                        'name' => 'fea_btn_text',
	                        'label' => esc_html__( 'Feature Button Text', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'View Features',
						),						

						array(
	                        'name' => 'fea_btn_link',
	                        'label' => esc_html__( 'Feature Button Link', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => '#',
						),							
						
						array(
	                        'name' => 'buy_btn_text',
	                        'label' => esc_html__( 'Buy Button Text', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'Buy Theme',
						),						

						array(
	                        'name' => 'buy_btn_link',
	                        'label' => esc_html__( 'Buy Button Link', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => '#',
						),										
								   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map				
		
		kc_add_map(
	        array(

	            'newsletter_area' => array(
	                'name' => esc_html__('Newsletter Area', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(

	                    array(
	                        'name' => 'sec_img',
	                        'label' => esc_html__( 'Section Image', 'kolo' ),
	                        'type' => 'attach_image',
	                        'admin_label' => true,
						),		                   

						array(
	                        'name' => 'sec_title',
	                        'label' => esc_html__( 'Section Title', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'Newsletter Subscription',	
						),							
						
						array(
	                        'name' => 'sec_subtitle',
	                        'label' => esc_html__( 'Section Content', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
							'value' => 'Be amongst the first to know about our news, ideas and latest fea',	
						),						

						array(
	                        'name' => 'sec_mailc_s_id',
	                        'label' => esc_html__( 'Mailchamp for WordPress Shortcode ID', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
						),			                  
									
								   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map		
				
				
		kc_add_map(
	        array(

	            'portfolio_area' => array(
	                'name' => esc_html__('Portfolios Area', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(

	                    array(
	                        'name' => 'sec_title',
	                        'label' => esc_html__( 'Section Title', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'Recent Projects'
						),			 	                  

						array(
	                        'name' => 'sec_subtitle',
	                        'label' => esc_html__( 'Section Content', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
							'value' => 'Sagittis an accumsan convallis, lectus ultrices feugiat'
						),			                  
									
								   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map		
			
		kc_add_map(
	        array(

	            'kfeature_area' => array(
	                'name' => esc_html__('Feature Area', 'kolo'),
	                'icon' => 'sl-rocket',
      						'nested'		=> true,	
	                'category' => 'Kolo Shortcodes',
	                'params' => array(

	                    array(
	                        'name' => 'sec_image',
	                        'label' => esc_html__( 'Upload Image', 'kolo' ),
	                        'type' => 'attach_image',
	                        'admin_label' => true,
						),			 	                  

						array(
	                        'name' => 'sec_title',
	                        'label' => esc_html__( 'Section Title', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'Optimized for mobile devices'
						),						

						array(
	                        'name' => 'sec_subtitle',
	                        'label' => esc_html__( 'Section SubTitle', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
							'value' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore 
							magna aliquam erat volutpat wisi enim ad minim veniam quis nostrud'
						),							
						
						array(
	                        'name' => 'btn_text',
	                        'label' => esc_html__( 'Button Text', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'View Features'
						),								
						
						array(
	                        'name' => 'btn_link',
	                        'label' => esc_html__( 'Button Link', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => '#'
						),			                  
									
								   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map				
		
		
		kc_add_map(
	        array(

	            'feat_single' => array(
	                'name' => esc_html__('Child of Feature', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(

						array(
	                        'name' => 'sec_icon',
	                        'label' => esc_html__( 'Section Icon', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'fa-check'
						),						

						array(
	                        'name' => 'sec_content',
	                        'label' => esc_html__( 'Section Content', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
							'value' => 'Lorem ipsum dolor and consectetur aliqua. Fusce accumsan purus pretium ligula vehicula, ut interdum nisl vulputate'
						),							
						
					
								   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map			
		
		
		kc_add_map(
	        array(

	            'testimonials_area' => array(
	                'name' => esc_html__('Testimonials Area', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(

						array(
	                        'name' => 'sec_bg_img',
	                        'label' => esc_html__( 'Upload BG Image', 'kolo' ),
	                        'type' => 'attach_image',
	                        'admin_label' => true,
						),						

						array(
	                        'name' => 'sec_title',
	                        'label' => esc_html__( 'Section Title', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
							'value' => 'What People Say About Us'
						),							
						
					
								   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map				
		
		kc_add_map(
	        array(

	            'clients_area' => array(
	                'name' => esc_html__('Client Area', 'kolo'),
	                'icon' => 'sl-rocket',
									'nested'		=> true,	
	                'category' => 'Kolo Shortcodes',
	                'params' => array(
								   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map		
				
				
		kc_add_map(
	        array(

	            'clients_single' => array(
	                'name' => esc_html__('Child of Client Area', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(

						array(
	                        'name' => 'sec_bg_img',
	                        'label' => esc_html__( 'Upload Client Image', 'kolo' ),
	                        'type' => 'attach_image',
	                        'admin_label' => true,
						),						

		   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map			
		
		kc_add_map(
	        array(

	            'pricing_table_area' => array(
	                'name' => esc_html__('Pricing Table Area', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(

						array(
	                        'name' => 'sec_title',
	                        'label' => esc_html__( 'Section Title', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => 'Pricing plans',
						),							
						
						array(
	                        'name' => 'sec_subtitle',
	                        'label' => esc_html__( 'Section Content', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
	                        'value' => 'Sagittis an accumsan convallis, lectus ultrices feugiat',
						),		

						
						array(
	                        'name' => 'number_post',
	                        'label' => esc_html__( 'Number of Post', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => '4',
						),						

		   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map		
		
		
		kc_add_map(
	        array(

	            'blog_area' => array(
	                'name' => esc_html__('Blog Area', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(

						array(
	                        'name' => 'sec_title',
	                        'label' => esc_html__( 'Section Title', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => 'Latest From Blog',
						),							
						
						array(
	                        'name' => 'sec_subtitle',
	                        'label' => esc_html__( 'Section Content', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
	                        'value' => 'Sagittis an accumsan convallis, lectus ultrices feugiat',
						),		

						
						array(
	                        'name' => 'number_post',
	                        'label' => esc_html__( 'Number of Post', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => '3',
						),						

		   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map			
		
		kc_add_map(
	        array(

	            'promo_bottom_area' => array(
	                'name' => esc_html__('Promo Bottom Area', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(

						array(
	                        'name' => 'sec_bg_img',
	                        'label' => esc_html__( 'Background Image', 'kolo' ),
	                        'type' => 'attach_image',
	                        'admin_label' => true,
						),							
						
						array(
	                        'name' => 'sec_title',
	                        'label' => esc_html__( 'Section Title', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
	                        'value' => 'Perfect for any kind of presentation',
						),		

						
						array(
	                        'name' => 'sec_subtitle',
	                        'label' => esc_html__( 'Section Content', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
	                        'value' => 'Use Kolo to showcase your mobile app, services or business projects',
						),							

						array(
	                        'name' => 'purchase_btn_text',
	                        'label' => esc_html__( 'Purchase Button Text', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => 'Purchase Now',
						),							
						
						array(
	                        'name' => 'purchase_btn_link',
	                        'label' => esc_html__( 'Purchase Button Link', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => '#',
						),									
						
						array(
	                        'name' => 'discover_btn_text',
	                        'label' => esc_html__( 'Discover Button Text', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => 'Discover More',
						),							
						
						array(
	                        'name' => 'discover_btn_link',
	                        'label' => esc_html__( 'Discover Button Link', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => '#',
						),						

		   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map				
		
		
		kc_add_map(
	        array(

	            'faqs_area' => array(
	                'name' => esc_html__('FAQs Area', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(
					
						
						array(
	                        'name' => 'sec_ques_label',
	                        'label' => esc_html__( 'Section Question Label', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => 'Q:',
						),		

						
						array(
	                        'name' => 'sec_ans_label',
	                        'label' => esc_html__( 'Section Answer Label', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => 'A:',
						),							

						array(
	                        'name' => 'sec_ques',
	                        'label' => esc_html__( 'Section Question', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
	                        'value' => 'Vivamus a purus lacus tempor volutpat?',
						),							
						
						array(
	                        'name' => 'sec_answer',
	                        'label' => esc_html__( 'Section Answer', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
	                        'value' => 'Nulla consequat massa quis enim. Veronum versus designus Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo',
						),									
				

		   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map			
		
		kc_add_map(
	        array(

	            'get_in_touch_area' => array(
	                'name' => esc_html__('Get In Touch Area', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(
					
						
						array(
	                        'name' => 'sec_title',
	                        'label' => esc_html__( 'Section Title', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => 'Get in touch',
						),		

						
						array(
	                        'name' => 'sec_subtitle',
	                        'label' => esc_html__( 'Section Subtitle', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
	                        'value' => 'We will get back to you as soon as possible',
						),							

						array(
	                        'name' => 'postal_address_label',
	                        'label' => esc_html__( 'Postal Address Label', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => 'Postal Address:',
						),							
						
						array(
	                        'name' => 'postal_address',
	                        'label' => esc_html__( 'Postal Address', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
	                        'value' => 'PO Box 16122 Collins Street West <br /> Victoria 8007 Australia',
						),								
						
						array(
	                        'name' => 'headquarters_label',
	                        'label' => esc_html__( 'Headquarters Label', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => 'Headquarters',
						),								
						
						array(
	                        'name' => 'headquarters_address',
	                        'label' => esc_html__( 'Headquarters', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
	                        'value' => '121 King Street, Melbourne <br /> Victoria 3000 Australia',
						),								
						
						array(
	                        'name' => 'phone_label',
	                        'label' => esc_html__( 'Phone Label', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => 'Phone',
						),							
						
						array(
	                        'name' => 'phone_number',
	                        'label' => esc_html__( 'Phone Number', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
	                        'value' => 'Phone Number: (123) 456 7890 <br /> Fax Number: (123) 456 7890',
						),									
						
						array(
	                        'name' => 'e_mail_label',
	                        'label' => esc_html__( 'Email Label', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => 'E-mail',
						),									
										
						array(
	                        'name' => 'e_mails',
	                        'label' => esc_html__( 'Emails', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
	                        'value' => 'Support: <a href="mailto:support@example.com">support@example.com</a> <br /> Sales: <a href="mailto:sales@example.com">sales@example.com</a>',
						),									
				

		   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map				
		
		
		kc_add_map(
	        array(

	            'contact_us_area' => array(
	                'name' => esc_html__('Contact Us Area', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(
					
						
						array(
	                        'name' => 'sec_title',
	                        'label' => esc_html__( 'Section Title', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => 'Get in touch',
						),		

						
						array(
	                        'name' => 'sec_subtitle',
	                        'label' => esc_html__( 'Section Subtitle', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
	                        'value' => 'We will get back to you as soon as possible',
						),							

						array(
	                        'name' => 'sec_cf7_id',
	                        'label' => esc_html__( 'Contact Form7 Shortcode ID', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,

						),							
						
						array(
	                        'name' => 'postal_address_label',
	                        'label' => esc_html__( 'Postal Address Label', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => 'Postal Address:',
						),							
						
						array(
	                        'name' => 'postal_address',
	                        'label' => esc_html__( 'Postal Address', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
	                        'value' => 'PO Box 16122 Collins Street West <br /> Victoria 8007 Australia',
						),								
						
						array(
	                        'name' => 'headquarters_label',
	                        'label' => esc_html__( 'Headquarters Label', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => 'Headquarters',
						),								
						
						array(
	                        'name' => 'headquarters_address',
	                        'label' => esc_html__( 'Headquarters', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
	                        'value' => '121 King Street, Melbourne <br /> Victoria 3000 Australia',
						),								
						
						array(
	                        'name' => 'phone_label',
	                        'label' => esc_html__( 'Phone Label', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => 'Phone',
						),							
						
						array(
	                        'name' => 'phone_number',
	                        'label' => esc_html__( 'Phone Number', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
	                        'value' => 'Phone Number: (123) 456 7890 <br /> Fax Number: (123) 456 7890',
						),									
						
						array(
	                        'name' => 'e_mail_label',
	                        'label' => esc_html__( 'Email Label', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => 'E-mail',
						),									
										
						array(
	                        'name' => 'e_mails',
	                        'label' => esc_html__( 'Emails', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
	                        'value' => 'Support: <a href="mailto:support@example.com">support@example.com</a> <br /> Sales: <a href="mailto:sales@example.com">sales@example.com</a>',
						),									
				

		   
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map			


		kc_add_map(
	        array(

	            'call_to_action_area' => array(
	                'name' => esc_html__('Call To Action Area', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(
					
						
						array(
	                        'name' => 'sec_bg_img',
	                        'label' => esc_html__( 'Upload Image', 'kolo' ),
	                        'type' => 'attach_image',
	                        'admin_label' => true,
						),		

						
						array(
	                        'name' => 'sec_title',
	                        'label' => esc_html__( 'Section Title', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => 'The best solution for your startup',
						),							
						
						array(
	                        'name' => 'sec_subtitle',
	                        'label' => esc_html__( 'Section Subtitle', 'kolo' ),
	                        'type' => 'textarea',
	                        'admin_label' => true,
	                        'value' => 'Aliquam a augue suscipit, bibendum luctus neque vestibulum laoreet',
						),							
						
						array(
	                        'name' => 'sec_button_text',
	                        'label' => esc_html__( 'Button Text', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => 'Let\'s Get Started',
						),							
						
						array(
	                        'name' => 'sec_button_url',
	                        'label' => esc_html__( 'Button Link', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => '#',
						),							

							
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map				
		
		kc_add_map(
	        array(

	            'tab_area' => array(
	                'name' => esc_html__('Tab Area', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(
					
						array(
	                        'name' => 'post_number',
	                        'label' => esc_html__( 'Number of Post', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => '3',
						),							
																		
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map			
		
		kc_add_map(
	        array(

	            'accordion_area' => array(
	                'name' => esc_html__('Accordion Area', 'kolo'),
	                'icon' => 'sl-rocket',
	                'category' => 'Kolo Shortcodes',
	                'params' => array(
					
						array(
	                        'name' => 'post_number',
	                        'label' => esc_html__( 'Number of Post', 'kolo' ),
	                        'type' => 'text',
	                        'admin_label' => true,
	                        'value' => '3',
						),							
																		
	                )
	            ),  // End of elemnt kc_icon 

	        ) 			
	    ); // End add map		
		
	

	
	} // End if

}  
 
