<?php
function kolo_header_option(){ 

global $kolo;

$kolo_site_logo = '';
$kolo_preloader_opt = '';
$kolo_homepage_opt = '';
$kolo_preloader_bg_color = '';
$kolo_preloader_imge = '';

if ( isset( $kolo['kolo_home_logo_ico']['url']) ) {
	$kolo_site_logo = $kolo['kolo_home_logo_ico']['url'];
}
if ( isset( $kolo['kolo_preloader_opt']) ) {
	$kolo_preloader_opt = $kolo['kolo_preloader_opt'];
}
if ( isset( $kolo['kolo_homepage_opt']) ) {
	$kolo_homepage_opt = $kolo['kolo_homepage_opt'];
}
if ( isset( $kolo['kolo_preloader_bg_color']) ) {
	$kolo_preloader_bg_color = $kolo['kolo_preloader_bg_color'];
}	
if ( isset( $kolo['kolo_preloader_imge']['url']) ) {
	$kolo_preloader_imge = $kolo['kolo_preloader_imge']['url'];
}

$kolo_default_site_logo = get_template_directory_uri(). '/img/logo.png';
?>

<?php if($kolo_preloader_opt == '1' && !$kolo_homepage_opt == '1') { ?>

	<!-- PRELOADER
	============================================= -->		
	<div class="animationload" style="background-color: <?php if(isset($kolo_preloader_bg_color)) { echo esc_attr($kolo_preloader_bg_color);}?>;">
		<div class="loader" style="background-image: url(<?php if(isset($kolo_preloader_imge)) { echo esc_url($kolo_preloader_imge);}?>);"></div>
	</div>	
	
<?php }elseif($kolo_preloader_opt == '1' && $kolo_homepage_opt == '1'){ ?>	

<?php if(is_front_page()) {?>

	<!-- PRELOADER
	============================================= -->		
	<div class="animationload" style="background-color: <?php if(isset($kolo_preloader_bg_color)) { echo esc_attr($kolo_preloader_bg_color);}?>;">
		<div class="loader" style="background-image: url(<?php if(isset($kolo_preloader_imge)) { echo esc_url($kolo_preloader_imge);}?>);"></div>
	</div>	
	
<?php } } ?>


		
	<!-- HEADER
	============================================= -->
	<header id="header" class="<?php if(is_user_logged_in()){ echo esc_attr('login_member_menu');}?>">		
		<div class="navbar navbar-fixed-top">	
			<div class="container">		
				<!-- Navigation Bar -->
				<div class="navbar-header">				
					<!-- Responsive Menu Button -->
					<button type="button" id="nav-toggle" class="navbar-toggle" data-toggle="collapse" data-target="#navigation-menu">
						<span class="sr-only"><?php esc_html_e('Toggle navigation' , 'kolo');?></span> 
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
					</button>
					
					<!-- Logo Image -->
					<a id="GoToHome" class="navbar-brand" href="<?php echo esc_url(home_url('/'));?>"><img src="<?php if($kolo_site_logo){ echo esc_url($kolo_site_logo);}else{ echo esc_url($kolo_default_site_logo);}?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" /></a>
					
				</div>	<!-- End Navigation Bar -->
				
				
				<!-- Navigation Menu -->
				<nav id="navigation-menu" class="collapse navbar-collapse">
					<?php kolo_main_menu();?>
				</nav>  <!-- End Navigation Menu -->
			
			</div>	  <!-- End container -->
		</div>	   <!-- End navbar fixed top  -->		
	</header>	<!-- END HEADER -->
<?php }


function kolo_blog_banner(){ 
global $kolo;
 $kolo_home_banner_img = '';
 
if(isset($kolo['kolo_home_banner_img']['url'])){
	$kolo_home_banner_img = $kolo['kolo_home_banner_img']['url'];
}

$kolo_default_banner_img = get_template_directory_uri(). '/img/parallax_bg/bottom-promo-line.jpg';

?>
	<section id="main_banner" style="background-image: url(<?php if($kolo_home_banner_img){ echo esc_url($kolo_home_banner_img);}else{ echo esc_url($kolo_default_banner_img);}?>); background-size: cover;">
		<div class="container">
			<div class="row">
				<div class="col-sm-6">
					<h3><?php esc_html_e("Latest Blog" , "kolo");?></h3>
				</div>
				
				<div class="col-sm-6 text-right">
					<a href="<?php echo esc_url(home_url('/'));?>"><?php esc_html_e('Home / Blog / ' , 'kolo');?></a> <?php the_title();?>		
				</div>
				 
			</div>
		</div>
	</section>	
<?php }

function kolo_shop_banner(){ 
global $kolo;
 $kolo_home_banner_img = '';
 
if(isset($kolo['kolo_home_banner_img']['url'])){
	$kolo_home_banner_img = $kolo['kolo_home_banner_img']['url'];
}

$kolo_default_banner_img = get_template_directory_uri(). '/img/parallax_bg/bottom-promo-line.jpg';

?>
	<section id="main_banner" style="background-image: url(<?php if($kolo_home_banner_img){ echo esc_url($kolo_home_banner_img);}else{ echo esc_url($kolo_default_banner_img);}?>); background-size: cover;">
		<div class="container">
			<div class="row">
				<div class="col-sm-6">
					<h3><?php esc_html_e("Shop" , "kolo");?></h3>
				</div>
				
				<div class="col-sm-6 text-right">
					<a href="<?php echo esc_url(home_url('/'));?>"><?php esc_html_e('Home / Shop  ' , 'kolo');?></a>		
				</div>
				 
			</div>
		</div>
	</section>	
<?php }

function kolo_archive_banner(){
global $kolo;
 $kolo_home_banner_img = '';
 
if(isset($kolo['kolo_home_banner_img']['url'])){
	$kolo_home_banner_img = $kolo['kolo_home_banner_img']['url'];
}

$kolo_default_banner_img = get_template_directory_uri(). '/img/parallax_bg/bottom-promo-line.jpg';

?>
	<section id="main_banner" style="background-image: url(<?php if($kolo_home_banner_img){ echo esc_url($kolo_home_banner_img);}else{ echo esc_url($kolo_default_banner_img);}?>); background-size: cover;">
		<div class="container">
			<div class="row">
				<div class="col-sm-6">
					<h3><?php esc_html_e('Archive' , 'kolo');?></h3>
				</div>
				
				<div class="col-sm-6 text-right">
					<a href="<?php echo esc_url(home_url('/'));?>"><?php esc_html_e('Home / Blog / ' , 'kolo');?></a> <?php the_archive_title();?>		
				</div>
				 
			</div>
		</div>
	</section>	
<?php }

function kolo_search_banner(){ 
	global $kolo;
	 $kolo_home_banner_img = '';
	 
	if(isset($kolo['kolo_home_banner_img']['url'])){
		$kolo_home_banner_img = $kolo['kolo_home_banner_img']['url'];
	}

	$kolo_default_banner_img = get_template_directory_uri(). '/img/parallax_bg/bottom-promo-line.jpg';

?>
	<section id="main_banner" style="background-image: url(<?php if($kolo_home_banner_img){ echo esc_url($kolo_home_banner_img);}else{ echo esc_url($kolo_default_banner_img);}?>); background-size: cover;">
		<div class="container">
			<div class="row">
				<div class="col-sm-6">
					<h3><?php esc_html_e('Search Result' , 'kolo');?></h3>
				</div>
				
				<div class="col-sm-6 text-right">
					<a href="<?php echo esc_url(home_url('/'));?>"><?php esc_html_e('Home /' , 'kolo');?></a> <?php printf( esc_html__( 'Search for: %s', 'kolo' ), '<span>' . esc_html(get_search_query()) . '</span>' ); ?>		
				</div>
				 
			</div>
		</div>
	</section>	
<?php }

function kolo_main_banner(){ 
global $kolo;
 $kolo_home_banner_img = '';
 
if(isset($kolo['kolo_home_banner_img']['url'])){
	$kolo_home_banner_img = $kolo['kolo_home_banner_img']['url'];
}
$kolo_meta_img = get_post_meta(get_the_ID(),'_kolo_upload_banner_image',true);

$kolo_default_banner_img = get_template_directory_uri(). '/img/parallax_bg/bottom-promo-line.jpg';

?>
	<section id="main_banner" style="background-image: url(<?php if($kolo_meta_img){ echo esc_url($kolo_meta_img);}elseif($kolo_home_banner_img){ echo esc_url($kolo_home_banner_img);}else{ echo esc_url($kolo_default_banner_img);}?>); background-size: cover;">
		<div class="container">
			<div class="row">
				<div class="col-sm-6">
					<h3><?php the_title();?></h3>
				</div>
				
				<div class="col-sm-6 text-right">
					<a href="<?php echo esc_url(home_url('/'));?>"><?php esc_html_e('Home /' , 'kolo');?></a> <?php if(!is_page()){ esc_html_e(' Blog / ', 'kolo');} the_title();?>		
				</div>
				 
			</div>
		</div>
	</section>	
<?php }

function kolo_single_shop_banner(){ 
global $kolo;
 $kolo_home_banner_img = '';
 
if(isset($kolo['kolo_home_banner_img']['url'])){
	$kolo_home_banner_img = $kolo['kolo_home_banner_img']['url'];
}
$kolo_meta_img = get_post_meta(get_the_ID(),'_kolo_upload_banner_image',true);

$kolo_default_banner_img = get_template_directory_uri(). '/img/parallax_bg/bottom-promo-line.jpg';

?>
	<section id="main_banner" style="background-image: url(<?php if($kolo_meta_img){ echo esc_url($kolo_meta_img);}elseif($kolo_home_banner_img){ echo esc_url($kolo_home_banner_img);}else{ echo esc_url($kolo_default_banner_img);}?>); background-size: cover;">
		<div class="container">
			<div class="row">
				<div class="col-sm-6">
					<h3><?php the_title();?></h3>
				</div>
				
				<div class="col-sm-6 text-right">
					<a href="<?php echo esc_url(home_url('/'));?>"><?php esc_html_e('Home /' , 'kolo');?></a> <?php if(!is_page()){ esc_html_e(' Shop / ', 'kolo');} the_title();?>		
				</div>
				 
			</div>
		</div>
	</section>	
<?php }

function kolo_404_banner(){
	global $kolo;
	 $kolo_home_banner_img = '';
	 
	if(isset($kolo['kolo_home_banner_img']['url'])){
		$kolo_home_banner_img = $kolo['kolo_home_banner_img']['url'];
	}

	$kolo_default_banner_img = get_template_directory_uri(). '/img/parallax_bg/bottom-promo-line.jpg';

?>
	<section id="main_banner" style="background-image: url(<?php if($kolo_home_banner_img){ echo esc_url($kolo_home_banner_img);}else{ echo esc_url($kolo_default_banner_img);}?>); background-size: cover;">
		<div class="container">
			<div class="row">
				<div class="col-sm-6">
					<h3><?php esc_html_e('404' , 'kolo');?></h3>
				</div>
				
				<div class="col-sm-6 text-right">
					<a href="<?php echo esc_url(home_url('/'));?>"><?php esc_html_e('Home /' , 'kolo');?></a> <?php esc_html_e(' 404 ', 'kolo');?>		
				</div>
				 
			</div>
		</div>
	</section>	
<?php }

function kolo_footer_opt(){ 

global $kolo;

$kolo_copywrite_text = '';


if ( isset( $kolo['kolo_copywrite_text']) ) {
	$kolo_copywrite_text = $kolo['kolo_copywrite_text'];
}


?>

	<!-- FOOTER
	============================================= -->
	<footer id="footer">
		<div class="container">	
			<!-- FOOTER LINKS -->
			<div class="row">		
				<div id="footer_socials" class="col-sm-12">	
					<?php kolo_footer_menu();?>
				</div>

			</div>	 <!-- END FOOTER LINKS -->	

			
			<!-- FOOTER COPYRIGHT -->
			<div class="row">			
				<div id="footer_copyright" class="col-sm-12">		
					<p><?php echo wp_kses($kolo_copywrite_text, array('br' => array() , 'span' => array() , 'a'=> array('href' => array(),'target' => array())  ) );?></p>	
				</div>			
			</div>	 <!-- END FOOTER COPYRIGHT -->				
		</div>	   <!-- End container -->							
	</footer>	<!-- END FOOTER -->	
<?php }

